/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.base.VWDebug;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Pattern;

public class VWLocale {
    private static final Pattern m_primaryTag = Pattern.compile("[ix]|[a-zA-Z]{2,3}");
    private static final Pattern m_subTag = Pattern.compile("[a-zA-Z0-9]{2,8}");
    private static final Pattern m_separator = Pattern.compile("[_-]");
    private static final HashMap m_locales = new HashMap();

    public static Locale parseLocale(String localeString) {
        Locale locale = null;
        if (m_locales.containsKey(localeString)) {
            return (Locale)m_locales.get(localeString);
        }
        String[] localeParts = VWLocale.validateLocaleName(localeString);
        if (localeParts != null && localeParts.length > 0) {
            locale = localeParts[2] != null ? new Locale(localeParts[0], localeParts[1], localeParts[2]) : (localeParts[1] != null ? new Locale(localeParts[0], localeParts[1]) : new Locale(localeParts[0]));
        }
        m_locales.put(localeString, locale);
        return locale;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   13 Jul 2006 23:34:46  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.2  $";
    }

    public static void main(String[] argv) {
        try {
            Locale[] locales = Locale.getAvailableLocales();
            for (int i = 0; i < locales.length; ++i) {
                Locale tmpLocale = VWLocale.parseLocale(locales[i].toString());
                System.out.println(locales[i].getDisplayName() + " = " + tmpLocale.getDisplayName());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        System.exit(0);
    }

    private static String[] validateLocaleName(String localeString) {
        if (localeString == null) {
            return null;
        }
        boolean bMatches = true;
        String[] localeParts = new String[]{null, null, null};
        String[] stringParts = m_separator.split(localeString);
        if (stringParts != null) {
            for (int i = 0; i < stringParts.length && bMatches && i <= 2; ++i) {
                if (i == 0) {
                    if (stringParts[0] != null && stringParts[0].length() > 0) {
                        bMatches = m_primaryTag.matcher(stringParts[0]).matches();
                        if (!bMatches) continue;
                        localeParts[0] = stringParts[0].toLowerCase();
                        continue;
                    }
                    localeParts[0] = "en";
                    continue;
                }
                if (stringParts[i].length() <= 0 || !(bMatches = m_subTag.matcher(stringParts[i]).matches())) continue;
                localeParts[i] = stringParts[i];
            }
        }
        if (localeParts[0] != null && localeParts[0].length() == 1 && localeParts[1] == null) {
            bMatches = false;
        }
        if (!bMatches) {
            if (localeString.equals("C")) {
                localeParts[0] = Locale.getDefault().getLanguage().toLowerCase();
                localeParts[1] = Locale.getDefault().getCountry();
                localeParts[2] = Locale.getDefault().getVariant();
            } else {
                localeParts = null;
            }
        }
        return localeParts;
    }
}

